<?php
/* *
 * 功能：即时到账交易接口接入页
 * 
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究支付宝接口使用，只是提供一个参考。
 */

require_once("./config.php");//核心文件

//构造要请求的参数数组，无需改动
$data = array(
		"pid" => trim($config['pid']),//商户ID
		"out_trade_no"	=> time(),//商户订单号
		"type" => $_GET['type'],//支付方式
		"name"	=> "测试支付",//商品名称
		"money"	=> $_GET['money'],//付款金额
		"param"	=> "",//自定义参数
		"notify_url" => $config['notify_url'],//异步通知地址
		"return_url" => $config['return_url']//同步跳转地址
);

//建立请求
ksort($data); //重新排序$data数组
reset($data); //内部指针指向数组中的第一个元素
$sign = ''; //初始化需要签名的字符为空
$urls = ''; //初始化URL参数为空
foreach ($data AS $key => $val) { //遍历需要传递的参数
    if ($val == ''||$key == 'sign'||$key == 'param') continue; //跳过这些不参数签名
    if ($sign != '') { //后面追加&拼接URL
        $sign .= "&";
        $urls .= "&";
    }
    $sign .= "$key=$val"; //拼接为url参数形式
    $urls .= "$key=" . urlencode($val); //拼接为url参数形式并URL编码参数值
}
$query = $urls . '&sign=' . md5($sign .$config['key']); //创建订单所需的参数
$url = $config['apiurl']."/submit.php?{$query}"; //支付页面

header("Location:{$url}"); //跳转到支付页面
?>